#include "../win32/common.h"
#include "../x68k/m68000.h"
#include "../win32/fileio.h"
#include "../win32/windraw.h"


extern void Save_State();
extern void Load_State();

	//int	m68000_ICount;
	//int	m68000_ICountBk;
	//int	ICount;
	//m68k_regs regs;


extern void Save_ADPCM( FILE *fp );
extern void Load_ADPCM( FILE *fp );

extern void Save_BG( FILE *fp );
extern void Load_BG( FILE *fp );

extern void Save_CRTC( FILE *fp );
extern void Load_CRTC( FILE *fp );

extern void Save_XDF( FILE *fp );
extern void Load_XDF( FILE *fp );

extern void Save_DMAC( FILE *fp );
extern void Load_DMAC( FILE *fp );

extern void Save_FDC( FILE *fp );
extern void Load_FDC( FILE *fp );

extern void Save_FDD( FILE *fp );
extern void Load_FDD( FILE *fp );

extern void Save_GVRAM( FILE *fp );
extern void Load_GVRAM( FILE *fp );

extern void Save_IOC( FILE *fp );
extern void Load_IOC( FILE *fp );

extern void Save_IRQH( FILE *fp );
extern void Load_IRQH( FILE *fp );

extern void Save_Memory( FILE *fp );
extern void Load_Memory( FILE *fp );

extern void Save_Mercury( FILE *fp );
extern void Load_Mercury( FILE *fp );

extern void Save_MFP( FILE *fp );
extern void Load_MFP( FILE *fp );

extern void Save_MIDI( FILE *fp );
extern void Load_MIDI( FILE *fp );

extern void Save_Palette( FILE *fp );
extern void Load_Palette( FILE *fp );

extern void Save_PIA( FILE *fp );
extern void Load_PIA( FILE *fp );

extern void Save_RTC( FILE *fp );
extern void Load_RTC( FILE *fp );

extern void Save_SASI( FILE *fp );
extern void Load_SASI( FILE *fp );

extern void Save_SCC( FILE *fp );
extern void Load_SCC( FILE *fp );

extern void Save_SCSIIPL( FILE *fp );
extern void Load_SCSIIPL( FILE *fp );

extern void Save_SRAM( FILE *fp );
extern void Load_SRAM( FILE *fp );

extern void Save_SysPort( FILE *fp );
extern void Load_SysPort( FILE *fp );

extern void Save_TVRAM( FILE *fp );
extern void Load_TVRAM( FILE *fp );

extern void Save_XDF( FILE *fp );
extern void Save_DIM( FILE *fp );
extern void Save_D88( FILE *fp );

extern void Load_XDF( FILE *fp );
extern void Load_DIM( FILE *fp );
extern void Load_D88( FILE *fp );

extern TVRAM_SetAllDirty();

extern DWORD FASTCALL DMA_Int(BYTE irq);
extern DWORD FASTCALL FDC_Int(BYTE irq);
extern DWORD FASTCALL FDD_Int(BYTE irq);
extern DWORD FASTCALL Mcry_IntCB(BYTE irq);
extern DWORD FASTCALL MFP_IntCallback(BYTE irq);
extern DWORD FASTCALL MIDI_Int(BYTE irq);
extern DWORD FASTCALL SASI_Int(BYTE irq);
extern DWORD FASTCALL SCC_Int(BYTE irq);
extern void FASTCALL cpu_setOPbase24(DWORD adr);

extern void Save_OPM( FILE *fp );
extern void Load_OPM( FILE *fp );


FILE *out;
extern char winx68k_dir[MAX_PATH];

void Save_State( int num )
{
	char buf[MAX_PATH];
	sprintf( buf, "%s%s%d", winx68k_dir, "state.st", num );
	//strcpy(buf, winx68k_dir);
	//strcat(buf, (char *) "state.st0");

	if( regs.pc==0 ) return;

	out = fopen(buf, "wb");
	if( !out ) return;

	Save_Memory( out );

	// 68kem
	fwrite( &m68000_ICount, 1, sizeof(m68000_ICount), out );
	fwrite( &m68000_ICountBk, 1, sizeof(m68000_ICountBk), out );
	fwrite( &ICount, 1, sizeof(ICount), out );
	fwrite( &regs, 1, sizeof(regs), out );

	if( regs.irq_callback==&DMA_Int ) fputc(0,out);
	if( regs.irq_callback==&FDC_Int ) fputc(1,out);
	if( regs.irq_callback==&FDD_Int ) fputc(2,out);
	if( regs.irq_callback==&Mcry_IntCB ) fputc(3,out);
	if( regs.irq_callback==&MFP_IntCallback ) fputc(4,out);
	if( regs.irq_callback==&MIDI_Int ) fputc(5,out);
	if( regs.irq_callback==&SASI_Int ) fputc(6,out);
	if( regs.irq_callback==&SCC_Int ) fputc(7,out);

	Save_ADPCM( out );
	Save_BG( out );
	Save_CRTC( out );
	Save_DMAC( out );
	Save_FDC( out );
	Save_FDD( out );
	Save_GVRAM( out );
	Save_IOC( out );
	Save_IRQH( out );
	Save_Mercury( out );
	Save_MFP( out );
	Save_MIDI( out );
	Save_Palette( out );
	Save_PIA( out );
	Save_RTC( out );
	Save_SASI( out );
	Save_SCC( out );
	Save_SCSIIPL( out );
	Save_SRAM( out );
	Save_SysPort( out );
	Save_TVRAM( out );

	Save_XDF( out );
	Save_DIM( out );
	Save_D88( out );

	//Save_OPM( out );

	fclose(out);
}


void Load_State( int num )
{
	char buf[MAX_PATH];

	sprintf( buf, "%s%s%d", winx68k_dir, "state.st", num );
	//strcpy(buf, winx68k_dir);
	//strcat(buf, (char *) "state.st");

	if( regs.pc==0 ) return;

	out = fopen(buf, "rb");
	if( !out ) return;

	Load_Memory( out );

	// 68kem
	fread( &m68000_ICount, 1, sizeof(m68000_ICount), out );
	fread( &m68000_ICountBk, 1, sizeof(m68000_ICountBk), out );
	fread( &ICount, 1, sizeof(ICount), out );
	fread( &regs, 1, sizeof(regs), out );

	num = fgetc( out );
	if( num==0 ) regs.irq_callback=DMA_Int;
	if( num==1 ) regs.irq_callback=FDC_Int;
	if( num==2 ) regs.irq_callback=FDD_Int;
	if( num==3 ) regs.irq_callback=Mcry_IntCB;
	if( num==4 ) regs.irq_callback=MFP_IntCallback;
	if( num==5 ) regs.irq_callback=MIDI_Int;
	if( num==6 ) regs.irq_callback=SASI_Int;
	if( num==7 ) regs.irq_callback=SCC_Int;

	cpu_setOPbase24( regs.pc );

	Load_ADPCM( out );
	Load_BG( out );
	Load_CRTC( out );
	Load_DMAC( out );
	Load_FDC( out );
	Load_FDD( out );
	Load_GVRAM( out );
	Load_IOC( out );
	Load_IRQH( out );
	Load_Mercury( out );
	Load_MFP( out );
	Load_MIDI( out );
	Load_Palette( out );
	Load_PIA( out );
	Load_RTC( out );
	Load_SASI( out );
	Load_SCC( out );
	Load_SCSIIPL( out );
	Load_SRAM( out );
	Load_SysPort( out );
	Load_TVRAM( out );

	Load_XDF( out );
	Load_DIM( out );
	Load_D88( out );

	//Load_OPM( out );

	
	TVRAM_SetAllDirty();
	WinDraw_ChangeSize();
	WinDraw_Redraw();

	fclose(out);
}